#include "stdafx.h"
#include "Utility.h"
#include "tchar.h"


CUtility::CUtility()
{
}

CUtility::~CUtility()
{
}

CString CUtility::DataToString(BYTE* pData, UINT nSize, BOOL bSeparator)
{
	CString strRet = _T("");
	if((pData != NULL) && (nSize > 0))
	{
		CHAR szData[MAX_PATH];
		for(UINT nCount = 0; nCount < nSize; nCount++)
		{

#ifdef WINCE
			sprintf(szData, "%02X", pData[nCount]);
#else
			sprintf_s(szData, MAX_PATH, "%02X", pData[nCount]);
#endif
			strRet += szData;
			if(bSeparator && (nCount != (nSize - 1)))
			{
				strRet += "-";
			}
		}
	}
	return strRet;
}

EERROR CUtility::SetDataByte(BYTE* pSrc, UINT nSrc, BYTE* pDest, UINT& nDestLen)
{
	EERROR eRet = ER_INVALID_POINTER;
	if((pSrc != NULL) && (pDest != NULL))
	{
		ZeroMemory(pDest, nDestLen);
		DWORD dwTotalData = nSrc <= nDestLen ? nSrc : nDestLen;
		memcpy_s(pDest, nDestLen, pSrc, dwTotalData);
		eRet = dwTotalData <= nDestLen ? ER_OK : ER_MORE_DATA;
		nDestLen = dwTotalData;
	}
	return eRet;
}

void CUtility::HexToByte(BYTE* pDataIn, UINT nSize, BYTE** pData, UINT& nSizeRet)
{
	if((pDataIn != NULL) && (nSize > 0))
	{
		nSizeRet = nSize / 2;
		*pData = new BYTE[nSizeRet];
		UINT nData = -1;
		char szDataConv[3] = {0, 0, 0};
		for(UINT nCount = 0; nCount < nSize / 2; nCount++)
		{
			szDataConv[0x00] = pDataIn[nCount * 2];
			szDataConv[0x01] = pDataIn[nCount * 2 + 1];

#ifdef WINCE
			sscanf(szDataConv, "%02X", &nData);
#else
			sscanf_s(szDataConv, "%02X", &nData);
#endif

			(*pData)[nCount] = nData;
		}
	}
}

BYTE* CUtility::SearchInBuffer(BYTE* pBuf, UINT nBufSize, BYTE* pSearch, UINT nSize)
{
	BOOL bFound = FALSE;
	BYTE* pRet = NULL;
	if(nBufSize > nSize)
	{
		UINT nNav = 0x00;
		while((pRet == NULL) && ((nNav + nSize) <= nBufSize))
		{
			if((nSize + nNav) <= nBufSize)
			{
				if(memcmp(pBuf + nNav, pSearch, nSize) == 0x00)
				{
					pRet = pBuf + nNav;
				}
				nNav++;
			}
		}
	}
	return pRet;
}


